#include "fundamentals/pubsub-helpers.hpp"

#include "fundamentals/rapidjson-helpers.hpp"
#include "fundamentals/serializable.hpp"

#include <rapidjson/document.h>

namespace Vape {

rapidjson::Document
CreatePublishMessage(const std::string &topic)
{
    rapidjson::Document d(rapidjson::kObjectType);

    rj::Set(d, "Type", "Publish");
    rj::Set(d, "Topic", topic);

    return d;
}

RJDocument
CreatePublishMessage2(const std::string &topic)
{
    RJDocument d(rapidjson::kObjectType);

    rj::Set(d, "Type", "Publish");
    rj::Set(d, "Topic", topic);

    return d;
}

rapidjson::Document
CreateValueUpdatedMessage(const ISerializable &serializable)
{
    rapidjson::Document d = CreatePublishMessage("ValueUpdated");
    auto &a               = d.GetAllocator();

    rj::Set(d, "Action", "Updated");
    rj::Set(d, "Path", serializable.path);
    rj::AddMember(d, "Value", serializable.Serialize(a));
    rj::Set(d, "IsTrigger", false);

    return d;
}

rapidjson::Document
CreateSetValueMessage(const ISerializable &serializable)
{
    rapidjson::Document d = CreatePublishMessage("SetValue");
    auto &a               = d.GetAllocator();

    rj::Set(d, "Path", serializable.path);
    rj::AddMember(d, "Value", serializable.Serialize(a));

    return d;
}

// RegisterValue is like SetValue except it doesn't force set the value, only sets the value if it doesn't already exist
rapidjson::Document
CreateRegisterValueMessage(const ISerializable &serializable)
{
    rapidjson::Document d = CreatePublishMessage("RegisterValue");
    auto &a               = d.GetAllocator();

    rj::Set(d, "Path", serializable.path);
    rj::AddMember(d, "Value", serializable.Serialize(a));

    return d;
}

rapidjson::Document
CreateValueRemovedMessage(const ISerializable &serializable)
{
    rapidjson::Document d = CreatePublishMessage("ValueUpdated");

    rj::Set(d, "Action", "Removed");
    rj::Set(d, "Path", serializable.path);

    return d;
}

rapidjson::Value
CreateSerializableValue(const ISerializable &serializable, rapidjson::Document::AllocatorType &a)
{
    rapidjson::Value v(rapidjson::kObjectType);

    rj::Set(v, "Path", serializable.path, a);
    rj::Set(v, "Temporary", serializable.remoteTemporary, a);
    rj::Set(v, "ReadOnly", serializable.remoteReadOnly, a);
    rj::AddMember(v, "Value", serializable.Serialize(a), a);
    rj::Set(v, "IsTrigger", false, a);

    return v;
}

}  // namespace Vape
