#include "fundamentals/serializable.hpp"

#include "fundamentals/serializablestore.hpp"

#include <pajlada/settings/signalargs.hpp>

namespace Vape {

ISerializable::ISerializable(const std::string &_path, bool _remoteReadOnly, bool _remoteTemporary)
    : IPathStorage(_path, _remoteReadOnly, _remoteTemporary)
{
    this->OnConstructed();
}

ISerializable::ISerializable(const ISerializable &other)
    : IPathStorage(static_cast<const IPathStorage &>(other))
{
    this->OnConstructed();
}

ISerializable::~ISerializable()
{
    this->OnDestructed();
}

void
ISerializable::PushObjectValueUpdated(const pajlada::Settings::SignalArgs &args)
{
    static SerializableStore &store = SerializableStore::serializableInstance();

    // [CORE UPDATE VALUE FROM BRIDGE 15] *actually* notify any outside listeners that this setting was updated
    store.serializableChanged.invoke(*this, args);
}

void
ISerializable::PushSerializableRegistered()
{
    SerializableStore::serializableInstance().objectRegistered.invoke(this);
}

void
ISerializable::PushSerializableUnregistered()
{
    SerializableStore::serializableInstance().objectUnregistered.invoke(this);
}

void
ISerializable::OnConstructed()
{
    // Register to SerializableStore
    SerializableStore::serializableInstance().doRegister(this);
}

void
ISerializable::OnDestructed()
{
    // Unregister from SerializableStore
    SerializableStore::serializableInstance().doUnregister(this);
}

}  // namespace Vape
