#include "fundamentals/serializablestore.hpp"

#include "fundamentals/websocket-helpers.hpp"

namespace Vape {

std::vector<const ISerializable *>
SerializableStore::GetObjectsMatchingPath(const std::string &listenerPath)
{
    std::vector<const ISerializable *> result;

    for (const ISerializable *serializable : this->getObjects()) {
        if (ws::MatchesPath(listenerPath, serializable->path)) {
            result.push_back(serializable);
        }
    }

    return result;
}

}  // namespace Vape
