#include "fundamentals/settings-common.hpp"

#include "fundamentals/rapidjson-helpers.hpp"

namespace Vape {

boost::optional<ValueUpdateAction>
ParseValueUpdateAction(rapidjson::Value &message)
{
    std::string path;
    bool isTrigger = false;

    if (!rj::Get(message, "Path", path)) {
        return boost::none;
    }

    if (!message.HasMember("Value")) {
        return boost::none;
    }

    rj::Get(message, "IsTrigger", isTrigger);

    return ValueUpdateAction{std::move(path), std::move(message["Value"]), isTrigger};
}

boost::optional<ConstValueUpdateAction>
ParseValueUpdateAction(const rapidjson::Value &message)
{
    std::string path;
    bool isTrigger = false;

    if (!rj::Get(message, "Path", path)) {
        return boost::none;
    }

    const auto valueIt = message.FindMember("Value");

    rj::Get(message, "IsTrigger", isTrigger);

    if (valueIt != message.MemberEnd()) {
        return ConstValueUpdateAction{std::move(path), valueIt->value, isTrigger};
    }

    return boost::none;
}

}  // namespace Vape
