#include "fundamentals/any-helpers.hpp"

#include <boost/any.hpp>
#include <gtest/gtest.h>

#include <cassert>
#include <functional>
#include <iostream>
#include <string>

static std::vector<boost::any> args;

template <typename F, typename Tuple, size_t... S>
decltype(auto)
apply_tuple_impl(F &&fn, Tuple &&t, std::index_sequence<S...>)
{
    return std::forward<F>(fn)(std::get<S>(std::forward<Tuple>(t))...);
}

template <typename F, typename Tuple>
decltype(auto)
apply_from_tuple(F &&fn, Tuple &&t)
{
    std::size_t constexpr tSize =
        std::tuple_size<typename std::remove_reference<Tuple>::type>::value;
    return apply_tuple_impl(std::forward<F>(fn), std::forward<Tuple>(t),
                            std::make_index_sequence<tSize>());
}

template <typename... Args>
void
testParseAnyArgsToTuple(std::function<void(Args...)> cb)
{
    auto xd = cb;

    std::tuple<Args...> arguments;
    Vape::ParseAnyArgsToTuple<Args...>(arguments, args);

    apply_from_tuple(cb, arguments);
}

void
xd(int a)
{
    std::cout << "a: " << a << '\n';
}

int
main(int argc, char **argv)
{
    using namespace std::placeholders;

    std::function<void(int)> f = std::bind(&xd, _1);

    args = std::vector<boost::any>{1};
    testParseAnyArgsToTuple(f);

    args = std::vector<boost::any>{2};
    testParseAnyArgsToTuple(f);

    args = std::vector<boost::any>{"asd"};
    testParseAnyArgsToTuple(f);

    float lol = M_PI;

    assert(std::cos(lol * 5.f) == cosf(lol * 5.f));
    assert(std::cos(lol * 52.f) == cosf(lol * 52.f));
    assert(std::cos(lol * 5.2f) == cosf(lol * 5.2f));

    ::testing::InitGoogleTest(&argc, argv);

    return RUN_ALL_TESTS();
}
