#include "fundamentals/syncpoint.hpp"

#include <gtest/gtest.h>
#include <atomic>
#include <thread>

using namespace Vape;
using namespace std::chrono_literals;

TEST(SyncPoint, TestOrder)
{
    std::atomic_int counter{0};
    SyncPoint syncPoint;

    std::thread t([&syncPoint, &counter](){
        auto token = syncPoint.GetWorkerToken();

        std::this_thread::sleep_for(100ms);

        EXPECT_EQ(counter.fetch_add(1), 0);
    });

    syncPoint.WaitForDone();
    EXPECT_EQ(counter.fetch_add(1), 1);

    t.join();
}
