#include "fundamentals/backoff.hpp"

#include <gtest/gtest.h>

using Vape::Backoff;

using namespace std::literals::chrono_literals;

TEST(BackoffDuration, Factor1)
{
    Backoff backoff(10ms, 100ms, 1, false);
    EXPECT_EQ(backoff.Duration(), 10ms);
    EXPECT_EQ(backoff.Duration(), 20ms);
    EXPECT_EQ(backoff.Duration(), 30ms);
    EXPECT_EQ(backoff.Duration(), 40ms);
    EXPECT_EQ(backoff.Duration(), 50ms);
    EXPECT_EQ(backoff.Duration(), 60ms);
    EXPECT_EQ(backoff.Duration(), 70ms);
    EXPECT_EQ(backoff.Duration(), 80ms);
    EXPECT_EQ(backoff.Duration(), 90ms);
    EXPECT_EQ(backoff.Duration(), 100ms);
    EXPECT_EQ(backoff.Duration(), 100ms);
}

TEST(BackoffDuration, Factor2)
{
    Backoff backoff(10ms, 100ms, 2, false);
    EXPECT_EQ(backoff.Duration(), 10ms);
    EXPECT_EQ(backoff.Duration(), 40ms);
    EXPECT_EQ(backoff.Duration(), 90ms);
    EXPECT_EQ(backoff.Duration(), 100ms);
    EXPECT_EQ(backoff.Duration(), 100ms);
}

TEST(BackoffDuration, Reset)
{
    Backoff backoff(10ms, 100ms, 1, false);
    EXPECT_EQ(backoff.Duration(), 10ms);
    EXPECT_EQ(backoff.Duration(), 20ms);
    EXPECT_EQ(backoff.Duration(), 30ms);
    backoff.Reset();
    EXPECT_EQ(backoff.Step(), 1);
    EXPECT_EQ(backoff.Duration(), 10ms);
    EXPECT_EQ(backoff.Duration(), 20ms);
    EXPECT_EQ(backoff.Duration(), 30ms);
    EXPECT_EQ(backoff.Duration(), 40ms);
    EXPECT_EQ(backoff.Duration(), 50ms);
    EXPECT_EQ(backoff.Duration(), 60ms);
    EXPECT_EQ(backoff.Duration(), 70ms);
    EXPECT_EQ(backoff.Duration(), 80ms);
    EXPECT_EQ(backoff.Duration(), 90ms);
    EXPECT_EQ(backoff.Duration(), 100ms);
    EXPECT_EQ(backoff.Duration(), 100ms);
    EXPECT_EQ(backoff.Duration(), 100ms);
    EXPECT_EQ(backoff.Duration(), 100ms);
}

TEST(BackoffDuration, WeirdData)
{
    Backoff backoff(100ms, 10ms, 1, false);
    EXPECT_EQ(backoff.Duration(), 10ms);
    EXPECT_EQ(backoff.Duration(), 10ms);
}

TEST(BackoffDuration, WeirdDataWithJitter)
{
    Backoff backoff(100ms, 10ms, 1, true);
    EXPECT_EQ(backoff.Duration(), 10ms);
    EXPECT_EQ(backoff.Duration(), 10ms);
}

TEST(BackoffDuration, WeirdDataBigFactor)
{
    Backoff backoff(100ms, 10ms, 20, false);
    EXPECT_EQ(backoff.Duration(), 10ms);
    EXPECT_EQ(backoff.Duration(), 10ms);
}

TEST(BackoffDuration, WeirdDataBigFactorWithJitter)
{
    Backoff backoff(100ms, 10ms, 20, true);
    EXPECT_EQ(backoff.Duration(), 10ms);
    EXPECT_EQ(backoff.Duration(), 10ms);
}
