#!/bin/sh

script_path=$(CDPATH='' cd -- "$(dirname -- "$0")" && pwd)
. "$script_path/../config.sh"

git_release="$(git describe 2>/dev/null)"
if [ ! $! ]; then
    git_release="dev"
fi

docker run \
    --user "$(id -u "$USER"):$(id -g "$USER")" \
    --name "$appname" \
    --mount type=bind,source="$PWD",destination=/build \
    --rm \
    -e GIT_BRANCH="$(git rev-parse --abbrev-ref HEAD)" \
    -e GIT_COMMIT="$(git rev-parse HEAD)" \
    -e GIT_RELEASE="$git_release" \
    vapour/"$appname"-build \
    /bin/bash -c './utils/build.sh --docker --release'
