import { SleeperFactory } from '../factory/sleeper';
import { Sleeper } from './sleeper';

export interface RequestLoopResult {
  error: boolean;
  message: string;
}

export type RequestFn = () => Promise<void>;
export type StatusFn = (res: RequestLoopResult) => void;

export class RequestLoop {
  static GetTime() {
    const now = new Date();
    return now.toLocaleTimeString('en-US');
  }

  running: boolean = false;
  runOnce = false;
  sleeper?: Sleeper;
  active: boolean = false;

  constructor(private fn: RequestFn, private statusFn: StatusFn, private sleepTime: number) {}

  async Run() {
    this.running = true;

    while (this.running) {
      if (this.active || this.runOnce) {
        if (this.runOnce) {
          console.log('Requesting API data manually');
        }

        try {
          await this.fn();
          this.statusFn({ error: false, message: `Success - ${RequestLoop.GetTime()}` });
        } catch (e) {
          this.statusFn({ error: true, message: e.message });
        }

        this.runOnce = false;
      }

      if (!this.runOnce) {
        this.sleeper = SleeperFactory.Create(this.sleepTime);
        await this.sleeper.Await();
        this.sleeper = undefined;
      }
    }
  }

  TriggerOnce() {
    this.runOnce = true;
    if (this.sleeper) {
      this.sleeper.EarlyOut();
    }
  }

  Stop() {
    this.running = false;
  }

  SetActive(a: boolean) {
    this.active = a;
  }
}
