import { expect } from 'chai';
import { describe, it } from 'mocha';
import { SleeperFactory } from '../factory/sleeper';

describe('Sleeper', () => {
  it('should expect the sleeper to await a timeout for a user-defined number of ms', async () => {
    const ms: number = 2;
    const now: number = Date.now();
    await SleeperFactory.Create(ms).Await();
    const after: number = Date.now();

    // It's hard to test this to be completely accurate, if it's on a slow computer an exact comparison may fail.
    expect(after - now).to.be.greaterThan(0);
    expect(after - now).to.be.lessThan(5);
  });
});
