import Timeout = NodeJS.Timeout;

export class Sleeper {
  promise: Promise<any>;

  constructor(ms: number) {
    this.promise = new Promise<any>(resolve => {
      let timeout: Timeout | undefined;
      timeout = setTimeout(() => {
        timeout = undefined;
        resolve();
      }, ms);

      this.EarlyOutInternal = () => {
        if (timeout) {
          clearTimeout(timeout as any);
          resolve();
        }
      };
    });
  }

  EarlyOut() {
    if (this.EarlyOutInternal) {
      this.EarlyOutInternal();
    }
  }

  public Await(): Promise<any> {
    return this.promise;
  }

  private EarlyOutInternal?(): void;
}
