import { expect } from 'chai';
import { describe, it } from 'mocha';
import { SyncList } from './synclist';

describe('SyncList', () => {
  it('Should update list', async () => {
    let added = 0;
    let removed = 0;

    const createElem = (i: number): string => {
      added++;
      return String(i);
    };

    const removeElem = (str: string) => {
      removed++;
      // console.log('Removed', str);
    };

    const resetCounters = () => {
      added = 0;
      removed = 0;
    };

    const list = new SyncList<number, string>(createElem, removeElem);

    resetCounters();
    expect(list.Sync([1, 2, 3, 4, 5])).to.equal(true);
    expect(list.GetElements()).to.deep.equal(['1', '2', '3', '4', '5']);
    expect(added).to.equal(5);
    expect(removed).to.equal(0);

    resetCounters();
    expect(list.Sync([1, 2, 4, 5])).to.equal(true);
    expect(list.GetElements()).to.deep.equal(['1', '2', '4', '5']);
    expect(added).to.equal(2);
    expect(removed).to.equal(3);

    resetCounters();
    expect(list.Sync([1, 3, 4, 5])).to.equal(true);
    expect(list.GetElements()).to.deep.equal(['1', '3', '4', '5']);
    expect(added).to.equal(1);
    expect(removed).to.equal(1);

    resetCounters();
    expect(list.Sync([1, 3, 4, 5])).to.equal(false);
    expect(list.GetElements()).to.deep.equal(['1', '3', '4', '5']);
    expect(added).to.equal(0);
    expect(removed).to.equal(0);

    resetCounters();
    expect(list.Clear()).to.equal(true);
    expect(list.GetElements()).to.deep.equal([]);
    expect(added).to.equal(0);
    expect(removed).to.equal(4);
  });
});
