import { expect } from 'chai';
import { after, describe, it } from 'mocha';

import { Sleeper } from '../classes/sleeper';
import { SleeperFactory } from './sleeper';

describe('SleeperFactory', () => {
  it('should return a valid instance of Sleeper', () => {
    let sleeper: Sleeper;
    after(() => {
      if (sleeper) {
        sleeper.EarlyOut();
      }
    });

    sleeper = SleeperFactory.Create(123);
    expect(sleeper instanceof Sleeper).to.equal(true);
  });
});
