import {TypeDesc} from 'vapour-connect/dist';
import {TriggerWS, TypeInstanceWS} from 'vapour-connect/dist/type';
import {VapourServiceBase} from 'vapour-service-base';
import {GameAPI} from './classes/api';
import {GameLeaderboard} from './classes/leaderboard';
import {RequestLoop, RequestLoopResult} from './classes/request-loop';
import Version from './version';

const TimerInterval = 10000;  // Update data every 10s if timer is enabled

export class GameApiService extends VapourServiceBase {
  api: GameAPI;
  leaderboard: GameLeaderboard;

  timerActive: TypeInstanceWS;
  triggerUpdate: TriggerWS;
  requestLoop: RequestLoop;

  constructor() {
    super('game-api-service', Version);

    this.api = new GameAPI();
    this.leaderboard = new GameLeaderboard(this, this.ClientBasePath());
    this.requestLoop = new RequestLoop(this.Update, this.ReportStatus, TimerInterval);

    this.timerActive = this.typeManager.GetConnectedTypeInstance(
        TypeDesc.Boolean, this.ClientBasePath() + '/timerActive');

    this.timerActive.Subscribe({ValueUpdated: (val: any) =>  {
      this.requestLoop.SetActive(val === true);
    }});

    this.triggerUpdate = this.typeManager.GetConnectedTrigger(
        TypeDesc.Boolean, this.ClientBasePath() + '/manualPull', () => this.requestLoop.TriggerOnce());

    this.vapour.ws.setValuePersistent(
        this.ClientBasePath() + '/authorizationIsSet', GameAPI.IsAuthorizationSet());

    this.requestLoop.Run();
  }

  ReportStatus = (res: RequestLoopResult) => {
    const basePath = this.ClientBasePath();

    this.vapour.ws.setValue(basePath + '/error', res.error);
    this.vapour.ws.setValue(basePath + '/status', res.message);

    if (res.error) {
      console.error(res.message);
    }
  };

   Update = async () => {
      await this.leaderboard.Update();
  };
}

const service = new GameApiService();
