export interface UserChannel {
  'Channel Name': string;
  'In Game Display Name': string;
}

export interface UserChannelData {
  Channels: UserChannel[];
}

export interface Token {
  access_token: string;
  expires_in?: number;
  expires_at: string;
  token_type?: string;
  internal_client?: boolean;
  client_service?: string;
  client_id?: string;
}

export enum TeamType {
  A = 'A',
  B = 'B',
}

export interface Team {
  teamType: TeamType;
  [index: string]: string;
}

export interface Leaderboard {
  gameId: string;
  eventId: string;
  eventWindowId: string;
  page: number;
  totalPages: number;
  updatedTime: string;
  entries: Team[];
}
