#!/bin/sh

set -e

script_path=$(CDPATH='' cd -- "$(dirname -- "$0")" && pwd)
. "$script_path/config.sh"

if [ ! -d node_modules ]; then
    if [ ! -f package.json ]; then
        echo "This script must be run in the root folder. If you are, make sure you've run npm install"
        exit 1
    fi
    npm install
fi

if [ ! -f node_modules/.bin/tsc ]; then
    echo "You must add typescript as a dev dependency"
    echo "  npm install typescript --save-dev"
    exit 1
fi

if [ ! -f node_modules/.bin/nexe ]; then
    echo "You must add nexe as a dev dependency"
    exit 1
fi

version=${version:-$(git describe 2>/dev/null | cut -b2-)}

for v in $(git for-each-ref --format='%(refname:short)' refs/remotes/origin --contains); do
    v=$(echo "$v" | sed 's/^origin\///')
    if [ "$(echo "$v" | cut -d'/' -f1)" = "release" ]; then
        version="v$(echo "$v" | cut -d'/' -f2)"
    fi
done

if [ -z "$version"  ]; then
    if [ -n "$GIT_RELEASE"  ]; then
        version="$(echo "$GIT_RELEASE" | cut -b2-)"
    else
        version="dev"
    fi
fi

new_version_path="$(mktemp)"

echo "const Version: string = '$version';
export default Version;" > "$new_version_path"

if ! diff src/version.ts "$new_version_path" 2>/dev/null 1>&2; then
    echo "New version: $version"
    mv "$new_version_path" src/version.ts
fi

rm -f src/new-version.ts

node_modules/.bin/tsc
node_modules/.bin/nexe . --targets linux-x64-12.15.0 --output="build/$appname"
