package permissions

import (
	"testing"

	"github.com/stretchr/testify/suite"
)

type constantsSuite struct {
	suite.Suite
}

func (t *constantsSuite) Test_Effect() {
	t.True(EffectAllow.Valid())
	t.False(Effect("invalidxd").Valid())
	t.Equal("Allow", EffectAllow.String())
	t.Equal("InvalidButYouCanStringThis", Effect("InvalidButYouCanStringThis").String())
}

func (t *constantsSuite) Test_Scope() {
	validScopes := []Scope{ScopeSubscribe, ScopePublish, ScopeAdmin}
	for _, scope := range validScopes {
		t.True(scope.Valid())
	}
	t.Equal("Subscribe", ScopeSubscribe.String())
	t.False(Scope("InvalidScope").Valid())
	t.Equal("InvalidButYouCanStringThis", Scope("InvalidButYouCanStringThis").String())
}

func TestConstants(t *testing.T) {
	suite.Run(t, &constantsSuite{})
}
