package permissions

// EvalItem is a base type for an item that is able to be evaluated by a rule
type EvalItem struct {
	Topic string
	Path  *Path
	Scope Scope
}

// EvalItemFromRule creates a new EvalItem struct from a rule struct
func EvalItemFromRule(r *Rule) *EvalItem {
	return &EvalItem{
		Topic: r.Topic,
		Path:  r.Path,
		Scope: r.Scope,
	}
}

// EvalItemFromQueryPermission creates a new EvalItem struct from the args passed to QueryPermission
func EvalItemFromQueryPermission(topic string, path *Path, scope Scope) *EvalItem {
	return &EvalItem{
		Topic: topic,
		Path:  path,
		Scope: scope,
	}
}
