package permissions

// Permissions is the struct used to directrly interact with all permissions in this library.
type Permissions struct {
	ruleset *Ruleset
}

// New constructs a new permissions struct
func New(rules []*Rule) *Permissions {
	return &Permissions{
		ruleset: RulesetFromRules(rules),
	}
}

// EvaluateRequiredClientPermissions tests rulesets against rules received from Core.
func (p *Permissions) EvaluateRequiredClientPermissions(rules []*Rule) bool {
	testRuleset := RulesetFromRules(rules)
	return p.ruleset.EvaluateOtherRuleset(testRuleset)
}

// QueryPermission tests if a single topic/path/scope is covered by rules received from Core.
func (p *Permissions) QueryPermission(topic, path string, scope Scope) bool {
	if path == "" {
		path = "/"
	}

	parsedPath, err := NewPath(path)
	if err != nil {
		return false
	}

	item := EvalItemFromQueryPermission(topic, parsedPath, scope)
	res, _ := p.ruleset.Evaluate(item)
	return res == PermissionResultFull
}

// QueryPermissionOverlap tests if a single topic/path/scope has an overlap with rules received from Core.
func (p *Permissions) QueryPermissionOverlap(topic, path string, scope Scope) bool {
	if path == "" {
		path = "/"
	}

	parsedPath, err := NewPath(path)
	if err != nil {
		return false
	}

	item := EvalItemFromQueryPermission(topic, parsedPath, scope)
	res, _ := p.ruleset.Evaluate(item)
	return res >= PermissionResultPartial
}
