package permissions

import (
	"testing"

	"github.com/stretchr/testify/suite"
)

type permissionsSuite struct {
	suite.Suite
}

func (t *permissionsSuite) Test_EvaluateRequiredClientPermissions() {
	rule1, err := NewRule(EffectAllow, "Test", "/a", ScopePublish)
	t.NoError(err, "failed to init rule1")
	rule2, err := NewRule(EffectAllow, "Test", "/a/*", ScopePublish)
	t.NoError(err, "failed to init rule2")
	rule3, err := NewRule(EffectAllow, "Test", "/a/b", ScopePublish)
	t.NoError(err, "failed to init rule3")
	rule4, err := NewRule(EffectAllow, "Test", "/nomatch", ScopePublish)
	t.NoError(err, "failed to init rule4")

	p := New([]*Rule{rule1, rule2})
	t.True(p.EvaluateRequiredClientPermissions([]*Rule{rule3}))
	t.False(p.EvaluateRequiredClientPermissions([]*Rule{rule4}))
}

func (t *permissionsSuite) Test_QueryPermission() {
	rule1, err := NewRule(EffectAllow, "Test", "/a", ScopePublish)
	t.NoError(err, "failed to init rule1")
	rule2, err := NewRule(EffectAllow, "Test", "/a/*", ScopePublish)
	t.NoError(err, "failed to init rule2")
	rule3, err := NewRule(EffectAllow, "Test", "/d/f", ScopePublish)
	t.NoError(err, "failed to init rule3")
	rule4, err := NewRule(EffectAllow, "Test", "/a/x/d", ScopePublish)
	t.NoError(err, "failed to init rule4")

	p := New([]*Rule{rule1, rule2, rule3, rule4})
	t.True(p.QueryPermission("Test", "/d/f", ScopePublish))
	t.True(p.QueryPermission("Test", "/a/f", ScopePublish))
	t.True(p.QueryPermission("Test", "/a/x/d", ScopePublish))
	t.False(p.QueryPermission("Test", "/4/Head/lol", ScopePublish))
	t.False(p.QueryPermission("Test", "", ScopePublish))
	t.False(p.QueryPermission("Test", "invalidpath**///", ScopePublish))
}

func (t *permissionsSuite) Test_QueryPermissionOverlap() {
	rule1, err := NewRule(EffectAllow, "Test", "/a/b/*", ScopePublish)
	t.NoError(err, "failed to init rule1")
	rule2, err := NewRule(EffectAllow, "Test", "/b/*", ScopePublish)
	t.NoError(err, "failed to init rule2")
	rule3, err := NewRule(EffectAllow, "Test", "/d/*/*/e", ScopePublish)
	t.NoError(err, "failed to init rule3")
	rule4, err := NewRule(EffectAllow, "Test", "/a/*/c/", ScopePublish)
	t.NoError(err, "failed to init rule4")

	p := New([]*Rule{rule1, rule2, rule3, rule4})
	t.True(p.QueryPermissionOverlap("Test", "/a/b/q", ScopePublish))
	t.True(p.QueryPermissionOverlap("Test", "/b/", ScopePublish))
	t.False(p.QueryPermissionOverlap("Test", "invalidpath**//", ScopePublish))
	t.True(p.QueryPermissionOverlap("Test", "/d/a/b/e", ScopePublish))
	t.True(p.QueryPermissionOverlap("Test", "", ScopePublish))
}

func TestPermissions(t *testing.T) {
	suite.Run(t, &permissionsSuite{})
}
