package permissions

import (
	"testing"

	"github.com/stretchr/testify/suite"
)

type ruleSuite struct {
	suite.Suite
}

func (t *ruleSuite) Test_EvaluatePaths() {
	rule1, err := NewRule(EffectAllow, "Test", "/a/", ScopePublish)
	t.NoError(err, "failed to construct rule1")

	rule2, err := NewRule(EffectAllow, "Test", "/a/b", ScopePublish)
	t.NoError(err, "failed to construct rule2")

	rule1Test := rule1.Evaluate(EvalItemFromRule(rule2))
	rule2Test := rule2.Evaluate(EvalItemFromRule(rule1))
	t.Equal(PermissionResultFull, rule1Test, "rule1 should have no permission result to rule2")
	t.Equal(PermissionResultPartial, rule2Test, "rule2 should have no permission result to rule1")
}

func (t *ruleSuite) Test_EvaluateTopics() {
	rule1, err := NewRule(EffectAllow, "*", "/a/b", ScopePublish)
	t.NoError(err, "failed to construct rule1")

	rule2, err := NewRule(EffectAllow, "Test", "/a/b", ScopePublish)
	t.NoError(err, "failed to construct rule2")

	rule1Test := rule1.Evaluate(EvalItemFromRule(rule2))
	rule2Test := rule2.Evaluate(EvalItemFromRule(rule1))
	t.Equal(PermissionResultFull, rule1Test, "rule1 should have no permission result to rule2")
	t.Equal(PermissionResultPartial, rule2Test, "rule2 should have no permission result to rule1")
}

func (t *ruleSuite) Test_EvaluateScope() {
	rule1, err := NewRule(EffectAllow, "Test", "/a/b", ScopePublish)
	t.NoError(err, "failed to construct rule1")

	rule2, err := NewRule(EffectAllow, "Test", "/a/b", ScopeSubscribe)
	t.NoError(err, "failed to construct rule2")

	rule1Test := rule1.Evaluate(EvalItemFromRule(rule2))
	rule2Test := rule2.Evaluate(EvalItemFromRule(rule1))
	t.Equal(PermissionResultNone, rule1Test, "rule1 should have no permission result to rule2")
	t.Equal(PermissionResultNone, rule2Test, "rule2 should have no permission result to rule1")
}

func (t *ruleSuite) Test_InvalidRulePath() {
	_, err := NewRule(EffectAllow, "Test", "invalidpath**", ScopePublish)
	t.Equal(ErrPathPrefixEmpty, err)
}

func TestRule(t *testing.T) {
	suite.Run(t, &ruleSuite{})
}
