package permissions

// Ruleset is a collection of parsed rules that can be evaluated as a unit
type Ruleset struct {
	Rules []*Rule
}

// RulesetFromRules creates a new Ruleset from a list of rules
func RulesetFromRules(rules []*Rule) *Ruleset {
	return &Ruleset{Rules: rules}
}

// GetSubsetRuleset filters the rules only containing ones that affect the item.
func (r *Ruleset) GetSubsetRuleset(item *EvalItem) *Ruleset {
	subset := []*Rule{}
	for _, rule := range r.Rules {
		if rule.Evaluate(item) > PermissionResultNone {
			subset = append(subset, rule)
		}
	}
	return RulesetFromRules(subset)
}

// EvaluateOtherRuleset evaluates an entire ruleset against this ruleset, and returns if all values
// in the other ruleset are fulfilled by this ruleset
func (r *Ruleset) EvaluateOtherRuleset(set *Ruleset) bool {
	// note: I wrote it this way rather then exiting in the for loop to just make it clearer to understand what
	// this actually does.
	found := false
	for _, rule := range set.Rules {
		if res, _ := r.Evaluate(EvalItemFromRule(rule)); res != PermissionResultFull {
			found = true
			break
		}
	}
	return found == false
}

// Evaluate evaluates a single Evalitem against this ruleset
func (r *Ruleset) Evaluate(item *EvalItem) (PermissionResult, []*Rule) {
	state := PermissionResultNone
	matchedRules := []*Rule{}

	for _, rule := range r.Rules {
		s := rule.Evaluate(item)
		if s == PermissionResultFull {
			matchedRules = append(matchedRules, rule)
			return s, matchedRules
		} else if s > state {
			state = s
			matchedRules = append(matchedRules, rule)
		}
	}

	return state, matchedRules
}
