package permissions

import (
	"testing"

	"github.com/stretchr/testify/suite"
)

type rulesetSuite struct {
	suite.Suite

	rule1 *Rule
	rule2 *Rule
	rule3 *Rule
	rule4 *Rule
	rule5 *Rule
}

func (t *rulesetSuite) SetupTest() {
	rule1, err := NewRule(EffectAllow, "Foo", "/a/", ScopePublish)
	t.NoError(err, "failed to construct rule1")
	rule2, err := NewRule(EffectAllow, "Bar", "/a/b", ScopePublish)
	t.NoError(err, "failed to construct rule2")
	rule3, err := NewRule(EffectAllow, "Foo", "/a/b", ScopePublish)
	t.NoError(err, "failed to construct rule3")
	rule4, err := NewRule(EffectAllow, "Bar", "/", ScopePublish)
	t.NoError(err, "failed to construct rule4")
	rule5, err := NewRule(EffectAllow, "Test", "/a/b", ScopePublish)
	t.NoError(err, "failed to construct rule5")

	t.rule1 = rule1
	t.rule2 = rule2
	t.rule3 = rule3
	t.rule4 = rule4
	t.rule5 = rule5
}

func (t *rulesetSuite) Test_CompareRulesets() {
	ruleset1 := RulesetFromRules([]*Rule{t.rule1, t.rule2, t.rule3, t.rule4, t.rule5})
	ruleset2 := RulesetFromRules([]*Rule{t.rule1, t.rule2, t.rule3, t.rule4, t.rule5})
	ruleset3 := RulesetFromRules([]*Rule{t.rule1, t.rule2, t.rule3, t.rule4})
	ruleset4 := RulesetFromRules([]*Rule{t.rule1, t.rule3, t.rule4, t.rule5})

	t.True(ruleset1.EvaluateOtherRuleset(ruleset2), "ruleset1.EvaluateOtherRuleset(ruleset2) should be true")
	t.True(ruleset1.EvaluateOtherRuleset(ruleset3), "ruleset1.EvaluateOtherRuleset(ruleset3) should be true")
	t.False(ruleset3.EvaluateOtherRuleset(ruleset1), "ruleset3.EvaluateOtherRuleset(ruleset1) should be false")
	t.True(ruleset4.EvaluateOtherRuleset(ruleset1), "ruleset4.EvaluateOtherRuleset(ruleset1) should be true")
}

func (t *rulesetSuite) Test_GetSubsetRuleset() {
	ruleset := RulesetFromRules([]*Rule{t.rule1, t.rule2, t.rule3})
	path, err := NewPath("")
	t.NoError(err, "failed to init path")
	item := EvalItemFromQueryPermission("Foo", path, ScopePublish)
	filtered := ruleset.GetSubsetRuleset(item)
	t.Equal(t.rule1, filtered.Rules[0])
	t.Equal(t.rule3, filtered.Rules[1])
	t.Equal(2, len(filtered.Rules))
}

func TestRuleset(t *testing.T) {
	suite.Run(t, &rulesetSuite{})
}
