#!/bin/sh

version=${version:-$(git describe 2>/dev/null | cut -b2-)}
if [ -z "$version"  ]; then
    if [ -n "$GIT_RELEASE"  ]; then
        version="$(echo "$GIT_RELEASE" | cut -b2-)"
    else
        version="dev"
    fi
fi

ldflags="-X main.Version=${version}"

if [ ! -d utils ]; then
    echo "This script is meant to be called from the root folder"
    exit 1
fi

rm -rf build*
mkdir build

# Build any utilities
for cmd in ./cmd/*; do
    [ -d "$cmd" ] || continue
    echo "Building $cmd ($version)"
    app_folder="$cmd"
    app_name=$(basename "$cmd")
    go build \
        -ldflags "${ldflags}" \
        -o build/"$app_name" \
        "$app_folder"
done

# Try to build the library itself
go build -ldflags "${ldflags}"
