# Insomnia

A schematic store for service RPC's to be used in testing with the Insomnia HTTP + GraphQL Client.

## Installation

To get started, you should download and install [Insomnia](https://insomnia.rest/download) for your operating system and architecture.

## Importing

You should clone this repository and import the schematic files. Although Insomnia offers a source control sync feature, It's paid and I don't think its worth it at all for the price. You can import by going to the application dashboard, then clicking `Create` and finally `File`.

## Supporting Vapour Certificates

Adding vapour certificates is mandatory for authorization inside nginx to network with downstream services like Core or Authenticator. If you plan on making REST API calls to Authenticator, you will **need** these steps.

### Adding a certificate

To add a certificate to the workspace, open the collection then click on the arrow next to `Vapour Microservice Playground` at the top of the application. This will open a modal. Navigate to `Client Certificates` and add your PFX certificate (.pem). Set the host to the vapour hostname associated with the certificate: `vapour-xxx-xxx`. In the next section you will learn to allow self signed certificates.

### Allowing self signed certificates

Vapour currently uses self-signed certificates, predictable OpenSSL will throw a self-signed error causing any REST requests to Vapour hosts to be closed immediately. You can disable this by navigating to `Application -> Settings -> General -> Request / Response` and disabling the `Validate certificates` option. **Please note this leaves you vulnerable to [MITM attacks](https://en.wikipedia.org/wiki/Man-in-the-middle_attack) so you should only use this when targeting a Vapour host.**
