/* -LICENSE-START-
 ** Copyright (c) 2013 Blackmagic Design
 **
 ** Permission is hereby granted, free of charge, to any person or organization
 ** obtaining a copy of the software and accompanying documentation covered by
 ** this license (the "Software") to use, reproduce, display, distribute,
 ** execute, and transmit the Software, and to prepare derivative works of the
 ** Software, and to permit third-parties to whom the Software is furnished to
 ** do so, all subject to the following:
 **
 ** The copyright notices in the Software and this entire statement, including
 ** the above license grant, this restriction and the following disclaimer,
 ** must be included in all copies of the Software, in whole or in part, and
 ** all derivative works of the Software, unless such copies or derivative
 ** works are solely in the form of machine-executable object code generated by
 ** a source language processor.
 **
 ** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 ** IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 ** FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
 ** SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
 ** FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
 ** ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 ** DEALINGS IN THE SOFTWARE.
 ** -LICENSE-END-
 */

#include "decklink_platform.h"

// Linux platform functions

HRESULT Initialize()
{
	return S_OK;
}	

HRESULT GetDeckLinkIterator(IDeckLinkIterator **deckLinkIterator)
{
	*deckLinkIterator = CreateDeckLinkIteratorInstance();
	if (*deckLinkIterator == NULL)
	{
		fprintf(stderr, "A DeckLink iterator could not be created.  The DeckLink drivers may not be installed.\n");
		return E_FAIL;
	}
	return S_OK;
}

HRESULT GetDeckLinkDiscoveryInstance(IDeckLinkDiscovery **deckLinkDiscovery)
{
    *deckLinkDiscovery = CreateDeckLinkDiscoveryInstance();
    if (*deckLinkDiscovery == NULL)
    {
        fprintf(stderr, "A DeckLink discovery instance could not be created.\n");
        return E_FAIL;
    }
    return S_OK;
}

void MutexInit(MUTEX* mutex)
{
    pthread_mutex_init(mutex, NULL);
}

void MutexLock(MUTEX* mutex)
{
    pthread_mutex_lock(mutex);  
}

void MutexUnlock(MUTEX* mutex)
{
    pthread_mutex_unlock(mutex);
    
}

void MutexDestroy(MUTEX* mutex)
{
    pthread_mutex_destroy(mutex);
    
}


void StringFromCharArray(STRINGOBJ* newStr, const char* charPtr)
{
	*newStr = strdup(charPtr);
}

void StringToCharArray(STRINGOBJ bmdStr, char* charArray, unsigned int arrayLength)
{
	strncpy(charArray, bmdStr, arrayLength);
	// ensure there's a null-term on the end (may not be if we concatenated the string)
	charArray[arrayLength-1] = '\0';
}


void StringToStdString(STRINGOBJ bmdStr, std::string& stdStr)
{
	stdStr = bmdStr;
}

INT32_SIGNED AtomicIncrement(volatile INT32_SIGNED* value)
{
	return __sync_add_and_fetch(value, 1);
}

INT32_SIGNED AtomicDecrement(volatile INT32_SIGNED* value)
{
	return __sync_sub_and_fetch(value, 1);
}

bool operator==(const REFIID& lhs, const REFIID& rhs)
{
	return memcmp(&lhs, &rhs, sizeof(REFIID)) == 0;
}
