#!/bin/sh

set -e

if [ -z "$SDK_FOLDER" ]; then
    echo "No SDK folder specified. Set your SDK_FOLDER environment variable"
    exit 1
fi

echo "Updating from SDK Folder '$SDK_FOLDER'"

# LINUX
# Remove all files
rm -rf Linux/*

# Copy example platform files for us to use
cp "$SDK_FOLDER/Examples/Linux/platform.cpp" Linux/decklink_platform.cpp
cp "$SDK_FOLDER/Examples/Linux/platform.h" Linux/decklink_platform.h

# Replace occurance of platform.h include in decklink_platform.cpp
sed -i 's/platform.h/decklink_platform.h/' Linux/decklink_platform.cpp

# Copy the actual SDK include files
cp "$SDK_FOLDER/Linux/include/"* Linux/
