# Vapour Multistream

## Environment variables
`VAPOUR_MULTISTREAM_OUTPUT_TYPE`  
Type: String  
*REQUIRED*.  
Valid options: ndi, decklink.  


`VAPOUR_MULTISTREAM_NDI_OUTPUT_NAME`  
Type: String  
*REQUIRED* if `VAPOUR_MULTISTREAM_OUTPUT_TYPE` is ndi.  
Sets the name of the NDI output.  


`VAPOUR_MULTISTREAM_HARDWARE_DECODER`  
Type: Boolean (1=true, 0=false)  
Default value: false  
Enables hardware decoding.  


`VAPOUR_MULTISTREAM_THREAD_AFFINITY`  
Type: Signed integer  
Default value: -1  
If value is between 0 and how many cores you have, sets the encoding threads to work on the specified core index.  

## Dependencies
| Library | Version |
| ------- | ------- |
| video/player-core | v2.10.2-web |
| fmtlib | v5.3.0 |

## Building with Docker

### Build image
`./utils/docker/image.sh`

### Push image
`./utils/docker/push.sh`

### Build multistream
`./utils/docker/build.sh.sh`

## Building with Manta
`./utils/manta.sh`
