if(WIN32)
    set(NDI_INCLUDE_DIRS
        "C:/Program Files/NewTek/NewTek NDI SDK/Include/"
        )

    set(NDI_LIBRARIES
        "C:\\Program Files\\NewTek\\NewTek NDI SDK\\Lib\\x64\\Processing.NDI.Lib.x64.lib"
        )
elseif(UNIX)
    set(NDI_SDK_Path "${CMAKE_SOURCE_DIR}/3rdParty/ndi-sdk")

    set(NDI_Found OFF)

    find_library(NDI_LIBRARY
        NAMES libndi libndi.so libndi.so.4.5.3
        HINTS "${NDI_SDK_Path}/lib/x86_64-linux-gnu")

    if(NDI_LIBRARY)
        message(STATUS "Found NDI at ${NDI_LIBRARY}")
        set(NDI_Found ON)
        add_library(NDI UNKNOWN IMPORTED)
        # TODO: Fix this bad include path
        set_target_properties(NDI PROPERTIES
            IMPORTED_LOCATION "${NDI_LIBRARY}"
            INTERFACE_INCLUDE_DIRECTORIES "${NDI_SDK_Path}/include"
            )
    else()
        if(NDI_FIND_REQUIRED)
            message(SEND_ERROR "Unable to find NDI")
        endif()
    endif()

    # add_library(ndi SHARED IMPORTED)
    # find_library(NDI_LIBRARY_PATH ndi HINTS "${NDI_SDK_Path}/lib/x86_64-linux-gnu")
    # set_target_properties(ndi PROPERTIES IMPORTED_LOCATION "${NDI_LIBRARY_PATH}")
    # target_link_libraries(ndi INTERFACE libndi)
    # target_include_directories(ndi INTERFACE "${NDI_SDK_Path}/include")
    # set(NDI_Libraries "${NDI_SDK_PATH}/lib/x86_64-linux-gnu/libndi.so")
endif()
