#pragma once

#include "./credentials/manager.hpp"
#include "./player/player.hpp"
#include "./settings/manager.hpp"
#include "./status/manager.hpp"
#include "fundamentals/signal-listener.hpp"
#include "permissions/ruleset.hpp"
#include "pubsub/service-base.hpp"
#include "pubsub/service-throttler.hpp"

#include <future>
#include <memory>
#include <thread>

namespace Vape {

/**
 * The main application class for the Multistream service
 */
class Application : public PubSub::Service::Base
{
    const std::string h{"Application"};
    SettingsManager settingsManager;
    StatusManager statusManager;
    CredentialsManager credentialsManager;

    Player player;

    std::unique_ptr<std::thread> playerThread;

    std::mutex playerStateMutex;
    StopReason playerState{StopReason::None};

    bool tryStart = false;
    PubSub::Service::Throttler throttler;

    Player::StartLock startLock;

    void StartPlayer();
    void QuitPlayer();

    friend class SettingsManager;

protected:
    /**
     * Inherited from PubSub::Service::Base
     * Create the ruleset needed by this service
     * @param uuid The client UUID received from Core
     */
    Ruleset CreateRequiredRuleset() final;

public:
    Application();
    ~Application();

    virtual void Poll() final;
};

}  // namespace Vape
