#include "config.hpp"

#include "api/common.hpp"
#include "debug/log.hpp"
#include "fundamentals/environment-args.hpp"
#include "fundamentals/helpers.hpp"

namespace Vape {

Config::Config()
    : outputType(Environment::ParseString("VAPOUR_MULTISTREAM_OUTPUT_TYPE"))
    , ndiOutputName(Environment::ParseString("VAPOUR_MULTISTREAM_NDI_OUTPUT_NAME"))
    , enableHardwareDecoder(Environment::ParseBool("VAPOUR_MULTISTREAM_HARDWARE_DECODER", false))
    , threadAffinity(Environment::ParseInt("VAPOUR_MULTISTREAM_THREAD_AFFINITY", -1))
    , fallbackClientID(Environment::ParseString("VAPOUR_MULTISTREAM_FALLBACK_CLIENT_ID",
                                                API::VAPOUR_API_CLIENT_ID))
    , coreHost(Environment::ParseString("VAPOUR_CLIENT_CORE_HOST"))
    , authenticatorUserID(Environment::ParseString("VAPOUR_MULTISTREAM_USERID"))
    , authenticatorUrl(Environment::ParseString("VAPOUR_MULTISTREAM_TOKEN_REFRESH_URL"))
    , authenticatorRefreshPassword(
          Environment::ParseString("VAPOUR_MULTISTREAM_TOKEN_REFRESH_PASSWORD"))
{
}

const Config &
Config::Get()
{
    static Config instance;
    return instance;
}

}  // namespace Vape
