#pragma once

#include <string>

namespace Vape {

class Config
{
    Config();

public:
    static const Config &Get();

    // Used by Unmanager mode to determine what outputter to start
    const std::string outputType;

    // Name of the output, used for NDI outputs
    const std::string ndiOutputName;

    const bool enableHardwareDecoder;

    const int threadAffinity;

    const std::string fallbackClientID;

    const std::string coreHost;

    // Used for the old authenticator
    const std::string authenticatorUserID;
    const std::string authenticatorUrl;
    const std::string authenticatorRefreshPassword;
};

}  // namespace Vape
