#include "./consumer-manager.hpp"

#include "./consumer-factory.hpp"
#include "debug/log.hpp"

namespace Vape {
static const std::string h{"ConsumerManager"};

ConsumerManager::ConsumerManager(OutputType _ouputType)
    : outputType(_ouputType)
{
}

ConsumerManager::~ConsumerManager()
{
}

std::pair<IVideoOutputConsumer *, ConsumerManager::GetResult>
ConsumerManager::GetConsumer(const ConsumerSettings &settings)
{
    // Settings has changed
    bool changed = this->lastSettings != settings;

    if (!changed && this->consumer && this->consumer->Valid()) {
        // Settings hasn't changed, and we have an existing consumer to return
        return {this->consumer.get(), GetResult::Reused};
    }

    // Store the last valid settings
    this->lastSettings = settings;

    // Destruct the old consumer
    this->consumer.reset();

    auto [cons, reason] = CreateConsumer(this->outputType, settings);

    if (!cons || reason != StopReason::None) {
        this->displayModeNamesSignal.Emit({});
        return {nullptr, GetResult::InvalidSettings};
    }

    this->displayModeNamesSignal.Emit(cons->GetDisplayModeNames());
    if (!cons->Valid()) {
        return {nullptr, GetResult::DeviceFailed};
    }

    this->consumer = std::move(cons);

    return {this->consumer.get(), GetResult::Created};
}

}  // namespace Vape
