#pragma once
#include "../settings/consumer.hpp"
#include "./ivideooutputconsumer.hpp"
#include "output-type.hpp"

#include <memory>
#include <utility>

namespace Vape {
/**
 * Manager class to create, initialize and hold the active consumer
 */
class ConsumerManager
{
    const OutputType outputType;

    /**
     * The last settings used to create the active consumer
     */
    ConsumerSettings lastSettings;

    /**
     * The active consumer
     */
    std::unique_ptr<IVideoOutputConsumer> consumer;

public:
    /**
     * The result of the GetConsumer call
     */
    enum class GetResult {
        DeviceFailed    = -2,
        InvalidSettings = -1,
        None            = 0,
        Created         = 1,
        Reused          = 2,
    };

    ConsumerManager(OutputType _outputType);
    ~ConsumerManager();

    /**
     * Get the output device based on the settings
     * If the settings hasn't changed and the device is valid, the existing device is returned
     * The device pointer is valid until the next call to GetConsumer
     */
    std::pair<IVideoOutputConsumer *, GetResult> GetConsumer(const ConsumerSettings &settings);

    /**
     * Signalled when a new device is created with all the modes the device accepts or an
     * empty list if the device fails to initialize
     */
    Signal::Provider<DisplayModeNames> displayModeNamesSignal;
};
}  // namespace Vape
