#pragma once
#include "./decklink-base.hpp"
#include "./decklink-iunknown.hpp"

extern "C" {
#include <libavutil/frame.h>
}

#include <map>
#include <mutex>
#include <string>

namespace Vape {
class AVFrameMemoryAllocator : public IDeckLinkMemoryAllocator
{
public:
    AVFrameMemoryAllocator();
    virtual ~AVFrameMemoryAllocator();

    IUNKNOWN_IMPL(IDeckLinkMemoryAllocator);

    // IDeckLinkMemoryAllocator methods
    virtual HRESULT STDMETHODCALLTYPE AllocateBuffer(unsigned int bufferSize,
                                                     void **allocatedBuffer) override;
    virtual HRESULT STDMETHODCALLTYPE ReleaseBuffer(void *buffer) override;
    virtual HRESULT STDMETHODCALLTYPE Commit() override;
    virtual HRESULT STDMETHODCALLTYPE Decommit() override;

    void PushAVFrame(AVFrame *frame);

private:
    struct StoredAVFrame {
        AVFrame *frame;
        int count;
    };

    std::map<void *, StoredAVFrame> frames;
    AVFrame *nextFrame = nullptr;
    std::mutex mutex;
    int allocationCount = 0;

    /**
     * Name for logging
     */
    const std::string h;
};
}  // namespace Vape
