#include "./decklink-genlock-status.hpp"

#include "./decklink-base.hpp"

namespace Vape {
DeckLinkGenlockStatus
GetDeckLinkGenLockStatus(const ScopedDeckLinkPointer<IDeckLinkOutput> &output)
{
    if (!output) {
        return DeckLinkGenlockStatus::NotSupported;
    }

    BMDReferenceStatus status;
    if (SUCCEEDED(output->GetReferenceStatus(&status))) {
        if (status & bmdReferenceNotSupportedByHardware) {
            return DeckLinkGenlockStatus::NotSupported;
        } else if (status & bmdReferenceLocked) {
            return DeckLinkGenlockStatus::Locked;
        } else {
            return DeckLinkGenlockStatus::NotLocked;
        }
    }

    return DeckLinkGenlockStatus::NotSupported;
}

}  // namespace Vape
