#pragma once
#include <ostream>

template <typename DeckLinkClass>
class ScopedDeckLinkPointer;

class IDeckLinkOutput;

namespace Vape {
enum class DeckLinkGenlockStatus {
    NotSupported = 0,
    NotLocked    = 1,
    Locked       = 2,
};

DeckLinkGenlockStatus GetDeckLinkGenLockStatus(
    const ScopedDeckLinkPointer<IDeckLinkOutput> &output);

inline std::ostream &
operator<<(std::ostream &os, DeckLinkGenlockStatus v)
{
    {
        switch (v) {
            case DeckLinkGenlockStatus::NotSupported:
                return os << "NotSupported";
            case DeckLinkGenlockStatus::NotLocked:
                return os << "NotLocked";
            case DeckLinkGenlockStatus::Locked:
                return os << "Locked";
            default:
                return os << "InternalError:" << static_cast<int>(v);
        }
    }
}
}  // namespace Vape
