#include "./ivideooutputconsumer.hpp"

namespace Vape {

bool
IVideoOutputConsumer::ScheduleFrame(StreamIndex index, AVFrame *frame, flicks displayTime)
{
    if (index == StreamIndex::Video) {
        return this->ScheduleVideoFrame(frame, displayTime);
    } else {
        return this->ScheduleAudioFrame(frame, displayTime);
    }
}

flicks
IVideoOutputConsumer::Playhead(StreamIndex index)
{
    if (index == StreamIndex::Video) {
        return this->VideoPlayhead();
    } else {
        return this->AudioPlayhead();
    }
}

flicks
IVideoOutputConsumer::BufferLength(StreamIndex index)
{
    if (index == StreamIndex::Video) {
        return this->VideoBufferLength();
    } else {
        return this->AudioBufferLength();
    }
}

flicks
IVideoOutputConsumer::TargetBufferLength(StreamIndex index)
{
    if (index == StreamIndex::Video) {
        return this->TargetVideoBufferLength();
    } else {
        return this->TargetAudioBufferLength();
    }
}
}  // namespace Vape
