#pragma once

#include <string>

namespace Vape {

enum class OutputType {
    Invalid,
    DeckLink,
    NDI,
};

inline OutputType
GetOutputType(const std::string &outputTypeName)
{
    if (outputTypeName == "decklink") {
        return OutputType::DeckLink;
    }

    if (outputTypeName == "ndi") {
        return OutputType::NDI;
    }

    return OutputType::Invalid;
}

}  // namespace Vape
