#include "fundamentals/rapidjson-helpers.hpp"

#include <string>

namespace Vape {
/**
 * Represents a token as received from Authenticator
 */
struct AuthenticatorCredentials {
    std::string expiresAt;
    std::string clientID;
    std::string accessToken;
};
}  // namespace Vape

namespace pajlada {
template <typename RJValue>
struct Deserialize<Vape::AuthenticatorCredentials, RJValue> {
    static Vape::AuthenticatorCredentials
    get(const RJValue &value, bool *error = nullptr)
    {
        using namespace Vape;

        AuthenticatorCredentials res;
        bool e = !rj::Get(value, "ExpiresAt", res.expiresAt) ||
                 !rj::Get(value, "ClientID", res.clientID) ||
                 !rj::Get(value, "AccessToken", res.accessToken);

        if (error) {
            *error = e;
        }

        return res;
    }
};

}  // namespace pajlada
