#include "fundamentals/rapidjson-helpers.hpp"

#include <string>

namespace Vape {
/**
 * Represents a token as received from Authenticator
 */
struct AuthenticatorOld {
    std::string accessToken;
};
}  // namespace Vape

namespace pajlada {
template <typename RJValue>
struct Deserialize<Vape::AuthenticatorOld, RJValue> {
    static Vape::AuthenticatorOld
    get(const RJValue &value, bool *error = nullptr)
    {
        using namespace Vape;

        AuthenticatorOld res;
        bool e = !rj::Get(value, "AccessToken", res.accessToken);

        if (error) {
            *error = e;
        }

        return res;
    }
};

}  // namespace pajlada
