#include "fundamentals/rapidjson-helpers.hpp"

#include <string>

namespace Vape {
/**
 * Represents a token as received from Authenticator
 */
struct AuthenticatorWhoIs {
    std::string clientID;
};
}  // namespace Vape

namespace pajlada {
template <typename RJValue>
struct Deserialize<Vape::AuthenticatorWhoIs, RJValue> {
    static Vape::AuthenticatorWhoIs
    get(const RJValue &value, bool *error = nullptr)
    {
        using namespace Vape;

        AuthenticatorWhoIs res;
        bool e = !rj::Get(value, "TwitchClientID", res.clientID);

        if (error) {
            *error = e;
        }

        return res;
    }
};

}  // namespace pajlada
