#pragma once

#include "./auth-credentials.hpp"
#include "./auth-old.hpp"
#include "./auth-whois.hpp"

#include <optional>
#include <string>
#include <utility>

namespace Vape {
namespace PubSub {
class Client;
}  // namespace PubSub
namespace API {
class Client;
}  // namespace API

class CredentialsManager
{
    std::optional<AuthenticatorWhoIs> whoisData;

    PubSub::Client &pubsubClient;
    API::Client &apiClient;

public:
    CredentialsManager(PubSub::Client &pubsubClient_, API::Client &apiClient_);
    std::pair<std::string, std::string> ResolveCredentials();
};
}  // namespace Vape
