#include "./avlogger.hpp"

#include "debug/log.hpp"

extern "C" {
#include <libavutil/log.h>
}

#include <vector>

namespace Vape {

void
AVLogCallback(void *ptr, int level, const char *fmt, va_list vl)
{
    std::string name = "Unknown";
    AVLogger::Find(ptr, &name);

    std::vector<char> buf(1024, 0);
    vsnprintf(buf.data(), buf.size(), fmt, vl);

    std::string str(buf.data());

    switch (level) {
        case AV_LOG_QUIET:
        case AV_LOG_DEBUG:
            return;

        case AV_LOG_VERBOSE:
            return Log::TTrace(name, str);

        case AV_LOG_INFO:
            return Log::TInfo(name, str);

        case AV_LOG_WARNING:
            return Log::TWarn(name, str);

        case AV_LOG_ERROR:
        case AV_LOG_FATAL:
        case AV_LOG_PANIC:
            return Log::TError(name, str);

        default:
            return;
    }
}

}  // namespace Vape
