#pragma once

#include <map>
#include <mutex>
#include <string>

namespace Vape {

class AVLogger
{
    static AVLogger &
    GetInstance()
    {
        static AVLogger logger;
        return logger;
    }

public:
    static void
    Register(void *avClass, std::string name)
    {
        auto &i = AVLogger::GetInstance();

        std::unique_lock<std::mutex> lock(i.dataMutex);

        i.data[avClass] = name;
    }

    static void
    Deregister(void *avClass)
    {
        if (!avClass) {
            return;
        }

        auto &i = AVLogger::GetInstance();

        std::unique_lock<std::mutex> lock(i.dataMutex);
        i.data.erase(avClass);
    }

    static bool
    Find(void *avClass, std::string *name)
    {
        if (name == nullptr) {
            return false;
        }

        auto &i = AVLogger::GetInstance();

        std::unique_lock<std::mutex> lock(i.dataMutex);
        auto it = i.data.find(avClass);
        if (it == i.data.end()) {
            return false;
        }

        *name = it->second;

        return true;
    }

    std::mutex dataMutex;
    std::map<void *, std::string> data;
};

void AVLogCallback(void *ptr, int level, const char *fmt, va_list vl);

}  // namespace Vape
