#pragma once
#include "../consumer/ivideooutputconsumer.hpp"
#include "./idecoder.hpp"

#include <memory>

class AVCodecContext;
class AVFilterGraph;

namespace Vape {
class SoundTouchWrapper;

class LibAVAudioDecoder : public IDecoder
{
    AVCodecContext *decoderContext;
    AVFilterGraph *filterGraph;
    std::unique_ptr<SoundTouchWrapper> soundTouch;
    IVideoOutputConsumer::AudioFormat audioFormat;

public:
    LibAVAudioDecoder(const IVideoOutputConsumer::AudioFormat &format);
    ~LibAVAudioDecoder();

    bool ProcessOneSample(flicks idealPlayheadTimestamp) final;
    bool GetOneFrame(const FrameCallback &cb) final;
    void SetPlaybackRate(float rate) final;

    Signal::Provider<std::vector<float>> audioPeakSignal;
};

}  // namespace Vape
