#pragma once

#include "../consumer/ivideooutputconsumer.hpp"
#include "vapour-player-core/types/audioconfiguration.hpp"
#include "vapour-player-core/types/videoconfiguration.hpp"
#include "vapour-player-core/types/wrappedmediasample.hpp"

extern "C" {
#include <libavutil/frame.h>
}

#include <functional>

class AVCodecContext;
class AVFilterGraph;

namespace Vape {
void CorrectAVFrameColorInfo(AVFrame *frame);

bool EnsureValidAVRational(AVRational *rational, const AVRational &r);

bool IsHwDecoder(AVCodecContext *decoderContext);

AVCodecContext *CreateVideoDecoder(std::string_view h, VideoConfiguration &cfg,
                                   bool forceSwDecode = false);
AVCodecContext *CreateAudioDecoder(std::string_view h, AudioConfiguration &cfg);

void ReleaseDecoder(AVCodecContext **decoderContext);

AVFilterGraph *CreateVideoFilterGraph(AVCodecContext *decoderContext,
                                      IVideoOutputConsumer::VideoFormat fmt);
AVFilterGraph *CreateAudioFilterGraph(AVCodecContext *decoderContext,
                                      IVideoOutputConsumer::AudioFormat fmt);
std::vector<float> GetPeaksForFrame(AVFrame *frame);

bool SendSampleToDecoder(AVCodecContext *decoder, PlayerCore::WrappedMediaSample &sample);
int GetFramesFromDecoder(AVCodecContext *decoder, int maxCount,
                         const std::function<bool(AVFrame *, flicks)> &cb);

bool SendFrameToFilterGraph(AVFilterGraph *filterGraph, AVFrame *frame);
int GetFramesFromFilterGraph(AVFilterGraph *filterGraph, int maxCount,
                             const std::function<bool(AVFrame *, flicks)> &cb);

}  // namespace Vape
