#pragma once
#include "../consumer/ivideooutputconsumer.hpp"
#include "./idecoder.hpp"

class AVCodecContext;
class AVFilterGraph;

namespace Vape {
class LibAVVideoDecoder : public IDecoder
{
    AVCodecContext *decoderContext;
    AVFilterGraph *filterGraph;
    PTSRewriter ptsRewriter;
    float playbackRate = 1.f;
    IVideoOutputConsumer::VideoFormat videoFormat;

public:
    LibAVVideoDecoder(const IVideoOutputConsumer::VideoFormat &format);
    ~LibAVVideoDecoder();

    bool ProcessOneSample(flicks idealPlayheadTimestamp) final;
    bool GetOneFrame(const FrameCallback &cb) final;
    void SetPlaybackRate(float rate) final;

    Signal::Provider<bool> timeBaseCorrectedSignal;
};

}  // namespace Vape
