#include "sample-buffer.hpp"

namespace Vape {
SampleBuffer::SampleBuffer()
    : lastPushedSample(std::chrono::system_clock::now())
{
}

std::shared_ptr<PlayerCore::WrappedMediaSample>
SampleBuffer::PopSample()
{
    if (this->packets.empty()) {
        return nullptr;
    }

    auto packet = std::move(this->packets.front());
    this->packetsTotalDuration -= packet->Duration();
    this->packets.pop_front();

    return packet;
}

void
SampleBuffer::PushSample(const std::shared_ptr<PlayerCore::WrappedMediaSample> &sample)
{
    this->packets.push_back(sample);
    this->packetsTotalDuration += sample->Duration();
    this->lastPushedSample = sample->sampleWrapTime;
}
}  // namespace Vape
