#pragma once
#include "vapour-player-core/types/wrappedmediasample.hpp"

#include <chrono>
#include <deque>
#include <memory>

namespace Vape {
class SampleBuffer
{
    flicks packetsTotalDuration{0};
    std::deque<std::shared_ptr<PlayerCore::WrappedMediaSample>> packets;
    std::chrono::system_clock::time_point lastPushedSample;

public:
    SampleBuffer();

    void PushSample(const std::shared_ptr<PlayerCore::WrappedMediaSample> &sample);
    std::shared_ptr<PlayerCore::WrappedMediaSample> PopSample();

    flicks
    DurationInBuffer() const
    {
        return this->packetsTotalDuration;
    }

    std::chrono::system_clock::time_point
    LastPushedSample() const
    {
        return this->lastPushedSample;
    }
};
}  // namespace Vape
